require "GameData"

local Debug_Line = false
Debug_Block_Line = false


local DRAG_BODYS_TAG = 0x80

guideID=nil

local GameControl = class("GameControl", function()
    local node = cc.Node:create()
    return node
end)

function GameControl:ctor()
   self._istouch=false
end

function GameControl:onEnter()
    --print("GameScene:onEnter")
end

function GameControl.create()
    local abc=GameControl.new()

    local function onNodeEvent(event)
        if "enter" == event then
            abc:onEnter()

        elseif "exit" == event then
            abc:onExit()
        end
    end

    abc:registerScriptHandler(onNodeEvent)
    abc:initWithLayer()
    return abc
end

function GameControl:initWithLayer()
    self._sprite=cc.Sprite:create("BlockMove_close.png")
    self._sprite:setPosition(display.size.width/2,display.size.height/2)
    self:addChild(self._sprite)
    print("GameControl:initWithLayer()")

    print("self._sprite:getPositionX()",self._sprite:getPositionX())




    local function onTouchBegan(touch, event)
        local location = touch:getLocation()
        if self._istouch==true then
            if cc.rectContainsPoint(self._sprite:getBoundingBox(), location) then
                --todo
                --处理
                return true
            end
        end
        return false
    end

    local function onTouchEnded(touch, event)
        
        local location = touch:getLocation()
        if self._istouch==true then
            if cc.rectContainsPoint(self._sprite:getBoundingBox(), location) then
                --todo
                --处理
                if gameScene._hp<3 then
                    --todo
                    gameScene._hp=gameScene._hp+1
                    --处理具体的画面变化
                    
                end

                print("onTouchEnded(touch, event)onTouchEnded(touch, event)")
            end
        end
    end

    local listener1=cc.EventListenerTouchOneByOne:create()                         --事件监听
    listener1:setSwallowTouches(true)
    listener1:registerScriptHandler(onTouchBegan,cc.Handler.EVENT_TOUCH_BEGAN )
    listener1:registerScriptHandler(onTouchEnded,cc.Handler.EVENT_TOUCH_ENDED )
    local eventDispatcher=self:getEventDispatcher()                                --事件分发
    eventDispatcher:addEventListenerWithSceneGraphPriority(listener1, self)

end

function GameControl:startAction(time)
    local guangquan=cc.Sprite:create("block_rotate_tishi.png")
    self:addChild(guangquan)
    guangquan:setPosition(self._sprite:getPosition())
    guangquan:setScale(2)

    local scale=cc.ScaleTo:create(time,1)
    local function scaleback()
        self._istouch=true
    end
    local function delback()
        self._istouch=false
        --处理
    end

    local scalefinish=cc.CallFunc:create(scaleback)
    local delayfinish=cc.CallFunc:create(delback)
    local del=cc.DelayTime:create(0.5)
    local seq=cc.Sequence:create(scale,scalefinish,del,delayfinish,cc.RemoveSelf:create())
    guangquan:runAction(seq)

end

function GameControl:startGame()

end

return GameControl

